<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use PDOException;

/**
 * VotacaoChapasregionais Controller
 *
 *
 * @method \App\Model\Entity\VotacaoChapasregionai[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class VotacaoChapasregionaisController extends AppController
{
    public $components = ['Filtros'];
    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add($usuario_id = null, $chapa_regional_selecionada = null)
    {

        $this->loadModel('Filiado');
        $this->loadModel('Chapasregionais');
        $this->loadModel('Configuracao');

        $config = $this->Configuracao->buscarDataHoraVotacao();
        if(!$config->periodo_votacao){
            $this->viewBuilder()->layout('ajax');
            $this->autoRender = false;
            $res = ['controller' => 'filiado', 'action' => 'error', 'dentro_periodo' => false];
            return $this->response->withType('json')->withStringBody(json_encode($res));
        }

        $connection = ConnectionManager::get('default');

        $this->Filiado->setConnection($connection);
        $this->Chapasregionais->setConnection($connection);

        $connection->begin();

        try {

            if(empty($this->request->getSession()->read('filiado'))){
                throw new PDOException('Sessão expirada ou não foi iniciada! Por favor faça login.', 0);
            }

            $filiado_votou_todos = $this->Filiado->filiadoVotouDthoraIp($usuario_id, 'VotacaoChapasregionais');
            if(!empty($filiado_votou_todos) && $filiado_votou_todos->votou == 1){
                throw new PDOException('Seus votos já foi realizado em '.date('d/m/Y', strtotime($filiado_votou_todos->votou_dthora)).' as '.date('H:i:s', strtotime($filiado_votou_todos->votou_dthora)).' pelo IP '.$filiado_votou_todos->votacao_fetems->ip, 1);
            }

            $filiado_votou_regional = $this->VotacaoChapasregionais->find('all')->where(['filiado_id' => json_decode(base64_decode($usuario_id))->id])->first();
            if(!empty($filiado_votou_regional)){
                throw new PDOException('Seu voto Regional já foi realizado', 2);
            }
            
            $cidade_id = $this->Filiado->getCidadeId($usuario_id);
            if(empty($cidade_id)) {
                throw new PDOException('Filiado não encontrado no sistema. Por favor, faça login.', 1);
            }

            $chapasRegionais = $this->Chapasregionais
                ->find('all')
                ->where(['lista_votacao' => 1]);

            $chapasregionais = $this->Filtros->arrayChavesEstrangeirasCidade($chapasRegionais, $cidade_id);
            
            $votacaoChapasregionai = $this->VotacaoChapasregionais->newEntity();
            if ($this->request->is('post')) {
                $this->viewBuilder()->layout('ajax');
                $this->autoRender = false;
                $res = ['msg' => 'Voto Regional realizado com sucesso', 'exists' => false, 'controller' => ( $cidade_id != 75 ? 'filiado' : 'votacao-chapasmunicipios'), 'dentro_periodo' => true];

                $usuario_id = json_decode(base64_decode($usuario_id))->id;
                if($this->VotacaoChapasregionais->find('list')->where(['filiado_id' => $usuario_id])->toArray() != []){
                    $res['msg'] = 'Este item já foi votado! Não é possível refazer o voto.';
                    $res['exists'] = true;    
                    return $this->response->withType('json')->withStringBody(json_encode($res));
                }

                $votacaoChapasregionai = $this->VotacaoChapasregionais->patchEntity($votacaoChapasregionai, $this->request->getData());
                $votacaoChapasregionai->filiado_id = intval($usuario_id);
                $votacaoChapasregionai->chapasregionais_id = (int) $chapa_regional_selecionada;
                $votacaoChapasregionai->dthora = date('Y-m-d H:i:s');
                $votacaoChapasregionai->votacao_concluida = 1;
                $votacaoChapasregionai->ip = $_SERVER['REMOTE_ADDR'];
                if(!$this->VotacaoChapasregionais->save($votacaoChapasregionai)){
                    throw new PDOException('Falha ao salvar votação Chapa Regional');
                }
                $connection->commit();
                return $this->response->withType('json')->withStringBody(json_encode($res));
            }

        } catch(PDOException $e) {
            $connection->rollback();

            $usuario = '';

            if($e->getCode() == 0){
                $controller = 'filiado';
                $action = 'index';
            } else if($e->getCode() == 1) {
                $controller = '/';
                $action = 'index';
            } else if($e->getCode() == 2) {
                $controller = 'votacao-chapasmunicipios';
                $action = 'add';
                $usuario = $usuario_id;
            }

            $this->Flash->error(__($e->getMessage()));
            $this->redirect(['controller' => $controller, 'action' => $action, $usuario]);
        }

        $this->set(compact('chapasregionais', 'cidade_id', 'usuario_id'));
    }

}
