<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Chapasfetems Model
 *
 * @method \App\Model\Entity\Chapasfetem get($primaryKey, $options = [])
 * @method \App\Model\Entity\Chapasfetem newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Chapasfetem[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Chapasfetem|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Chapasfetem saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Chapasfetem patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Chapasfetem[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Chapasfetem findOrCreate($search, callable $callback = null, $options = [])
 */
class ChapasfetemsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('chapasfetems');
        $this->setDisplayField('nome');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmptyString('nome');

        $validator
            ->integer('lista_votacao')
            ->allowEmptyString('lista_votacao');

        return $validator;
    }
}
