<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * VotacaoChapasmunicipios Model
 *
 * @property \App\Model\Table\FiliadoTable&\Cake\ORM\Association\BelongsTo $Filiado
 * @property \App\Model\Table\ChapasmunicipiosTable&\Cake\ORM\Association\BelongsTo $Chapasmunicipios
 *
 * @method \App\Model\Entity\VotacaoChapasmunicipio get($primaryKey, $options = [])
 * @method \App\Model\Entity\VotacaoChapasmunicipio newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\VotacaoChapasmunicipio[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\VotacaoChapasmunicipio|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\VotacaoChapasmunicipio saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\VotacaoChapasmunicipio patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\VotacaoChapasmunicipio[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\VotacaoChapasmunicipio findOrCreate($search, callable $callback = null, $options = [])
 */
class VotacaoChapasmunicipiosTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('votacao_chapasmunicipios');
        $this->setDisplayField('chapasmunicipios_id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Filiado', [
            'foreignKey' => 'filiado_id',
        ]);
        $this->belongsTo('Chapasmunicipios', [
            'foreignKey' => 'chapasmunicipios_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->dateTime('dthora')
            ->allowEmptyDateTime('dthora');

        $validator
            ->scalar('ip')
            ->maxLength('ip', 20)
            ->allowEmptyString('ip');

        $validator
            ->integer('votacao_concluida')
            ->allowEmptyString('votacao_concluida');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['filiado_id'], 'Filiado'));
        $rules->add($rules->existsIn(['chapasmunicipios_id'], 'Chapasmunicipios'));

        return $rules;
    }
}
