<?php
final class AreaController extends AppController{ 

    # página inicial do módulo Area
    function index(){
        $this->setTitle('Area');
    }

    # lista de Areas
    # renderiza a visão /view/Area/all.php
    function all(){
        $this->setTitle('Areas');
        $p = new Paginate('Area', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('titulo', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Areas', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Area
    # renderiza a visão /view/Area/view.php
    function view(){
        try {
            $this->set('Area', new Area((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Area', 'all');
        }
    }

    # formulário de cadastro de Area
    # renderiza a visão /view/Area/add.php
    function add(){
        $this->setTitle('Adicionar Area');
        $this->set('Area', new Area);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Area
    # (true)redireciona ou (false) renderiza a visão /view/Area/add.php
    function post_add(){
        $this->setTitle('Adicionar Area');
        $Area = new Area();
        $this->set('Area', $Area);
        try {
            $Area->save($_POST);
            new Msg(__('Area cadastrado com sucesso'));
            $this->go('Area', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Area
    # renderiza a visão /view/Area/edit.php
    function edit(){
        $this->setTitle('Editar Area');
        try {
            $this->set('Area', new Area((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Area', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Area
    # (true)redireciona ou (false) renderiza a visão /view/Area/edit.php
    function post_edit(){
        $this->setTitle('Editar Area');
        try {
            $Area = new Area((int) $_POST['id']);
            $this->set('Area', $Area);
            $Area->save($_POST);
            new Msg(__('Area atualizado com sucesso'));
            $this->go('Area', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Area
    # renderiza a /view/Area/delete.php
    function delete(){
        $this->setTitle('Apagar Area');
        try {
            $this->set('Area', new Area((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Area', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Area
    # redireciona para Area/all
    function post_delete(){
        try {
            $Area = new Area((int) $_POST['id']);
            $Area->delete();
            new Msg(__('Area apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Area', 'all');
    }

}