<?php
final class ContatoController extends AppController{ 

    # página inicial do módulo Contato
    function index(){
        $this->setTitle('Contato');
    }

    # lista de Contatos
    # renderiza a visão /view/Contato/all.php
    function all(){
        $this->setTitle('Contatos');
        $p = new Paginate('Contato', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('nome', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Contatos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Contato
    # renderiza a visão /view/Contato/view.php
    function view(){
        try {
            $this->set('Contato', new Contato((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Contato', 'all');
        }
    }

    # formulário de cadastro de Contato
    # renderiza a visão /view/Contato/add.php
    function add(){
        $this->setTitle('Adicionar Contato');
        $this->set('Contato', new Contato);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Contato
    # (true)redireciona ou (false) renderiza a visão /view/Contato/add.php
    function post_add(){
        $this->setTitle('Adicionar Contato');
        $Contato = new Contato();
        $this->set('Contato', $Contato);
        try {
            $Contato->save($_POST);
            new Msg(__('Contato cadastrado com sucesso'));
            $this->go('Contato', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Contato
    # renderiza a visão /view/Contato/edit.php
    function edit(){
        $this->setTitle('Editar Contato');
        try {
            $this->set('Contato', new Contato((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Contato', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Contato
    # (true)redireciona ou (false) renderiza a visão /view/Contato/edit.php
    function post_edit(){
        $this->setTitle('Editar Contato');
        try {
            $Contato = new Contato((int) $_POST['id']);
            $this->set('Contato', $Contato);
            $Contato->save($_POST);
            new Msg(__('Contato atualizado com sucesso'));
            $this->go('Contato', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Contato
    # renderiza a /view/Contato/delete.php
    function delete(){
        $this->setTitle('Apagar Contato');
        try {
            $this->set('Contato', new Contato((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Contato', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Contato
    # redireciona para Contato/all
    function post_delete(){
        try {
            $Contato = new Contato((int) $_POST['id']);
            $Contato->situacao=4;
            $Contato->save();
            new Msg(__('Contato apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Contato', 'all');
    }

}