<?php
final class CorrecaotrabalhoController extends AppController{ 

    # página inicial do módulo Correcaotrabalho
    function index(){
        $this->setTitle('Correcaotrabalho');
    }

    # lista de Correcaotrabalhos
    # renderiza a visão /view/Correcaotrabalho/all.php
    function all(){
        $this->setTitle('Correcaotrabalhos');
        $p = new Paginate('Correcaotrabalho', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('id', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Correcaotrabalhos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Correcaotrabalho
    # renderiza a visão /view/Correcaotrabalho/view.php
    function view(){
        try {
            $this->set('Correcaotrabalho', new Correcaotrabalho((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Correcaotrabalho', 'all');
        }
    }

    # formulário de cadastro de Correcaotrabalho
    # renderiza a visão /view/Correcaotrabalho/add.php
    function add(){
        $this->setTitle('Adicionar Correcaotrabalho');
        $this->set('Correcaotrabalho', new Correcaotrabalho);
        $this->set('Trabalhos',  Trabalhos::getList());
        $this->set('Situacaotrabalhos',  Situacaotrabalho::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Correcaotrabalho
    # (true)redireciona ou (false) renderiza a visão /view/Correcaotrabalho/add.php
    function post_add(){
        $this->setTitle('Adicionar Correcaotrabalho');
        $Correcaotrabalho = new Correcaotrabalho();
        $this->set('Correcaotrabalho', $Correcaotrabalho);
        try {
            $Correcaotrabalho->save($_POST);
            new Msg(__('Correcaotrabalho cadastrado com sucesso'));
            $this->go('Correcaotrabalho', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Trabalhos',  Trabalhos::getList());
        $this->set('Situacaotrabalhos',  Situacaotrabalho::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Correcaotrabalho
    # renderiza a visão /view/Correcaotrabalho/edit.php
    function edit(){
        $this->setTitle('Editar Correcaotrabalho');
        try {
            $this->set('Correcaotrabalho', new Correcaotrabalho((int) $this->getParam('id')));
            $this->set('Trabalhos',  Trabalhos::getList());
            $this->set('Situacaotrabalhos',  Situacaotrabalho::getList());
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Correcaotrabalho', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Correcaotrabalho
    # (true)redireciona ou (false) renderiza a visão /view/Correcaotrabalho/edit.php
    function post_edit(){
        $this->setTitle('Editar Correcaotrabalho');
        try {
            $Correcaotrabalho = new Correcaotrabalho((int) $_POST['id']);
            $this->set('Correcaotrabalho', $Correcaotrabalho);
            $Correcaotrabalho->save($_POST);
            new Msg(__('Correcaotrabalho atualizado com sucesso'));
            $this->go('Correcaotrabalho', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Trabalhos',  Trabalhos::getList());
        $this->set('Situacaotrabalhos',  Situacaotrabalho::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Correcaotrabalho
    # renderiza a /view/Correcaotrabalho/delete.php
    function delete(){
        $this->setTitle('Apagar Correcaotrabalho');
        try {
            $this->set('Correcaotrabalho', new Correcaotrabalho((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Correcaotrabalho', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Correcaotrabalho
    # redireciona para Correcaotrabalho/all
    function post_delete(){
        try {
            $Correcaotrabalho = new Correcaotrabalho((int) $_POST['id']);
            $Correcaotrabalho->delete();
            new Msg(__('Correcaotrabalho apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Correcaotrabalho', 'all');
    }

}