<?php
final class Data_programacaoController extends AppController{ 

    # página inicial do módulo Data_programacao
    function index(){
        $this->setTitle('Data_programacao');
    }

    # lista de Data_programacaos
    # renderiza a visão /view/Data_programacao/all.php
    function all(){
        $this->setTitle('Data_programacaos');
        $p = new Paginate('Data_programacao', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('dia', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Data_programacaos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Data_programacao
    # renderiza a visão /view/Data_programacao/view.php
    function view(){
        try {
            $this->set('Data_programacao', new Data_programacao((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Data_programacao', 'all');
        }
    }

    # formulário de cadastro de Data_programacao
    # renderiza a visão /view/Data_programacao/add.php
    function add(){
        $this->setTitle('Adicionar Data_programacao');
        $this->set('Data_programacao', new Data_programacao);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Data_programacao
    # (true)redireciona ou (false) renderiza a visão /view/Data_programacao/add.php
    function post_add(){
        $this->setTitle('Adicionar Data_programacao');
        $Data_programacao = new Data_programacao();
        $this->set('Data_programacao', $Data_programacao);
        try {
            $Data_programacao->save($_POST);
            new Msg(__('Data_programacao cadastrado com sucesso'));
            $this->go('Data_programacao', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Data_programacao
    # renderiza a visão /view/Data_programacao/edit.php
    function edit(){
        $this->setTitle('Editar Data_programacao');
        try {
            $this->set('Data_programacao', new Data_programacao((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Data_programacao', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Data_programacao
    # (true)redireciona ou (false) renderiza a visão /view/Data_programacao/edit.php
    function post_edit(){
        $this->setTitle('Editar Data_programacao');
        try {
            $Data_programacao = new Data_programacao((int) $_POST['id']);
            $this->set('Data_programacao', $Data_programacao);
            $Data_programacao->save($_POST);
            new Msg(__('Data_programacao atualizado com sucesso'));
            $this->go('Data_programacao', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Data_programacao
    # renderiza a /view/Data_programacao/delete.php
    function delete(){
        $this->setTitle('Apagar Data_programacao');
        try {
            $this->set('Data_programacao', new Data_programacao((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Data_programacao', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Data_programacao
    # redireciona para Data_programacao/all
    function post_delete(){
        try {
            $Data_programacao = new Data_programacao((int) $_POST['id']);
            $Data_programacao->delete();
            new Msg(__('Data_programacao apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Data_programacao', 'all');
    }

}