<?php
final class FormapgController extends AppController{ 

    # página inicial do módulo Formapg
    function index(){
        $this->setTitle('Formapg');
    }

    # lista de Formapgs
    # renderiza a visão /view/Formapg/all.php
    function all(){
        $this->setTitle('Formapgs');
        $p = new Paginate('Formapg', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('nome', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Formapgs', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Formapg
    # renderiza a visão /view/Formapg/view.php
    function view(){
        try {
            $this->set('Formapg', new Formapg((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Formapg', 'all');
        }
    }

    # formulário de cadastro de Formapg
    # renderiza a visão /view/Formapg/add.php
    function add(){
        $this->setTitle('Adicionar Formapg');
        $this->set('Formapg', new Formapg);
    }

    # recebe os dados enviados via post do cadastro de Formapg
    # (true)redireciona ou (false) renderiza a visão /view/Formapg/add.php
    function post_add(){
        $this->setTitle('Adicionar Formapg');
        $Formapg = new Formapg();
        $this->set('Formapg', $Formapg);
        try {
            $Formapg->save($_POST);
            new Msg(__('Formapg cadastrado com sucesso'));
            $this->go('Formapg', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
    }

    # formulário de edição de Formapg
    # renderiza a visão /view/Formapg/edit.php
    function edit(){
        $this->setTitle('Editar Formapg');
        try {
            $this->set('Formapg', new Formapg((int) $this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Formapg', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Formapg
    # (true)redireciona ou (false) renderiza a visão /view/Formapg/edit.php
    function post_edit(){
        $this->setTitle('Editar Formapg');
        try {
            $Formapg = new Formapg((int) $_POST['id']);
            $this->set('Formapg', $Formapg);
            $Formapg->save($_POST);
            new Msg(__('Formapg atualizado com sucesso'));
            $this->go('Formapg', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
    }

    # Confirma a exclusão ou não de um(a) Formapg
    # renderiza a /view/Formapg/delete.php
    function delete(){
        $this->setTitle('Apagar Formapg');
        try {
            $this->set('Formapg', new Formapg((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Formapg', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Formapg
    # redireciona para Formapg/all
    function post_delete(){
        try {
            $Formapg = new Formapg((int) $_POST['id']);
            $Formapg->delete();
            new Msg(__('Formapg apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Formapg', 'all');
    }

}