<?php
final class GrupoController extends AppController{ 

    # página inicial do módulo Grupo
    function index(){
        $this->setTitle('Grupo');
    }

    # lista de Grupos
    # renderiza a visão /view/Grupo/all.php
    function all(){
        $this->setTitle('Grupos');
        $p = new Paginate('Grupo', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('titulo', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Grupos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Grupo
    # renderiza a visão /view/Grupo/view.php
    function view(){
        try {
            $this->set('Grupo', new Grupo((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Grupo', 'all');
        }
    }

    # formulário de cadastro de Grupo
    # renderiza a visão /view/Grupo/add.php
    function add(){
        $this->setTitle('Adicionar Grupo');
        $this->set('Grupo', new Grupo);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Grupo
    # (true)redireciona ou (false) renderiza a visão /view/Grupo/add.php
    function post_add(){
        $this->setTitle('Adicionar Grupo');
        $Grupo = new Grupo();
        $this->set('Grupo', $Grupo);
        try {
            $Grupo->save($_POST);
            new Msg(__('Grupo cadastrado com sucesso'));
            $this->go('Grupo', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Grupo
    # renderiza a visão /view/Grupo/edit.php
    function edit(){
        $this->setTitle('Editar Grupo');
        try {
            $this->set('Grupo', new Grupo((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Grupo', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Grupo
    # (true)redireciona ou (false) renderiza a visão /view/Grupo/edit.php
    function post_edit(){
        $this->setTitle('Editar Grupo');
        try {
            $Grupo = new Grupo((int) $_POST['id']);
            $this->set('Grupo', $Grupo);
            $Grupo->save($_POST);
            new Msg(__('Grupo atualizado com sucesso'));
            $this->go('Grupo', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Grupo
    # renderiza a /view/Grupo/delete.php
    function delete(){
        $this->setTitle('Apagar Grupo');
        try {
            $this->set('Grupo', new Grupo((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Grupo', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Grupo
    # redireciona para Grupo/all
    function post_delete(){
        try {
            $Grupo = new Grupo((int) $_POST['id']);
            $Grupo->delete();
            new Msg(__('Grupo apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Grupo', 'all');
    }

}