<?php
final class ImagenslocalController extends AppController{ 
    # página inicial do módulo Imagenslocal
    function index(){
        $this->setTitle('Imagenslocal');
    }

    # lista de Imagenslocais
    # renderiza a visão /view/Imagenslocal/all.php
    function all(){
        $this->setTitle('Imagenslocais');
        $p = new Paginate('Imagenslocal', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('imagem', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Imagenslocais', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Imagenslocal
    # renderiza a visão /view/Imagenslocal/view.php
    function view(){
        try {
            $this->set('Imagenslocal', new Imagenslocal((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Imagenslocal', 'all');
        }
    }

    # formulário de cadastro de Imagenslocal
    # renderiza a visão /view/Imagenslocal/add.php
    function add(){
        $this->setTitle('Adicionar Imagenslocal');
        $this->set('Imagenslocal', new Imagenslocal);
        $this->set('Locais',  Local::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Imagenslocal
    # (true)redireciona ou (false) renderiza a visão /view/Imagenslocal/add.php
    function post_add(){
        $this->setTitle('Adicionar Imagenslocal');
        try {
            $numFile = count(array_filter($_FILES['imagens']['name']));
            $imagens = $_FILES['imagens'];
            if ($numFile > 0) {
                $arquivos = array(array());
                foreach ($_FILES as $key => $info) {
                    foreach ($info as $key => $dados) {
                        for ($i = 0; $i < sizeof($dados); $i++) {
                            $arquivos[$i][$key] = $info[$key][$i];
                        }
                    }
                }
                foreach ($arquivos as $file) {
                    $ImagemUploader = new ImageUploader($file, 1200);
                    $path = "/local/" . $_POST['idLocal'];
                    $nome = time() . $file['name'];
                    if ($ImagemUploader->save($nome, $path)){
                        $imagemLocal = new Imagenslocal();
                        $this->set('Imagenslocal', $imagemLocal);
                        $imagemLocal->idLocal = $_POST['idLocal'];
                        $imagemLocal->imagem = $path . "/" . $nome;
                        $imagemLocal->situacao = 2;
                        $imagemLocal->save();
                    }
                }
                new Msg(__('Imagenslocal cadastrado com sucesso'));
                $this->go('Imagenslocal', 'all');
            }else{
                new Msg('Selecione pelo menos uma imagem',3);
                $this->go('Imagenslocal', 'all');
            }

        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Locais',  Local::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Imagenslocal
    # renderiza a visão /view/Imagenslocal/edit.php
    function edit(){
        $this->setTitle('Editar Imagenslocal');
        try {
            $this->set('Imagenslocal', new Imagenslocal((int) $this->getParam('id')));
            $this->set('Locais',  Local::getList());
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Imagenslocal', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Imagenslocal
    # (true)redireciona ou (false) renderiza a visão /view/Imagenslocal/edit.php
    function post_edit(){
        $this->setTitle('Editar Imagenslocal');
        try {
            $Imagenslocal = new Imagenslocal((int) $_POST['id']);
            $this->set('Imagenslocal', $Imagenslocal);
            $Imagenslocal->save($_POST);
            new Msg(__('Imagenslocal atualizado com sucesso'));
            $this->go('Imagenslocal', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Locais',  Local::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Imagenslocal
    # renderiza a /view/Imagenslocal/delete.php
    function delete(){
        $this->setTitle('Apagar Imagenslocal');
        try {
            $this->set('Imagenslocal', new Imagenslocal((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Imagenslocal', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Imagenslocal
    # redireciona para Imagenslocal/all
    function post_delete(){
        try {
            $Imagenslocal = new Imagenslocal((int) $_POST['id']);
            $Imagenslocal->situacao=4;
            $Imagenslocal->save();
            new Msg(__('Imagenslocal apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Imagenslocal', 'all');
    }

}