<?php
final class LocalController extends AppController{ 

    # página inicial do módulo Local
    function index(){
        $this->setTitle('Local');
    }

    # lista de Locais
    # renderiza a visão /view/Local/all.php
    function all(){
        $this->setTitle('Locais');
        $p = new Paginate('Local', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('id', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $c->addCondition('situacao','<>',4);
        $this->set('Locais', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Local
    # renderiza a visão /view/Local/view.php
    function view(){
        try {
            $this->set('Local', new Local((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Local', 'all');
        }
    }

    # formulário de cadastro de Local
    # renderiza a visão /view/Local/add.php
    function add(){
        $this->setTitle('Adicionar Local');
        $this->set('Local', new Local);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Local
    # (true)redireciona ou (false) renderiza a visão /view/Local/add.php
    function post_add(){
        $this->setTitle('Adicionar Local');
        $Local = new Local();
        $this->set('Local', $Local);
        try {
            if($Local->save($_POST)) {
                $numFile = count(array_filter($_FILES['imagens']['name']));
                $imagens = $_FILES['imagens'];
                if ($numFile > 0) {
                    $arquivos = array(array());
                    foreach ($_FILES as $key => $info) {
                        foreach ($info as $key => $dados) {
                            for ($i = 0; $i < sizeof($dados); $i++) {
                                $arquivos[$i][$key] = $info[$key][$i];
                            }
                        }
                    }
                    foreach ($arquivos as $file) {
                        $ImagemUploader = new ImageUploader($file, 1200);
                        $path = "/local/" . $Local->id;
                        $nome = time() . $file['name'];
                        if ($ImagemUploader->save($nome, $path)){
                            $imagemLocal = new Imagenslocal();
                            $imagemLocal->idLocal = $Local->id;
                            $imagemLocal->imagem = $path . "/" . $nome;
                            $imagemLocal->situacao = 2;
                            $imagemLocal->save();
                        }
                    }
                }
            }
            new Msg(__('Local cadastrado com sucesso'));
            $this->go('Local', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Local
    # renderiza a visão /view/Local/edit.php
    function edit(){
        $this->setTitle('Editar Local');
        try {
            $this->set('Local', new Local((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Local', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Local
    # (true)redireciona ou (false) renderiza a visão /view/Local/edit.php
    function post_edit(){
        $this->setTitle('Editar Local');
        try {
            $Local = new Local((int) $_POST['id']);
            $this->set('Local', $Local);
            $Local->save($_POST);
            new Msg(__('Local atualizado com sucesso'));
            $this->go('Local', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Local
    # renderiza a /view/Local/delete.php
    function delete(){
        $this->setTitle('Apagar Local');
        try {
            $this->set('Local', new Local((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Local', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Local
    # redireciona para Local/all
    function post_delete(){
        try {
            $Local = new Local((int) $_POST['id']);
            $Local->situacao=4;
            $Local->save();
            new Msg(__('Local apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Local', 'all');
    }

}