<?php
final class PatrocinadoresController extends AppController{ 

    # página inicial do módulo Patrocinadores
    function index(){
        $this->setTitle('Patrocinadores');
    }

    # lista de Patrocinadores
    # renderiza a visão /view/Patrocinadores/all.php
    function all(){
        $this->setTitle('Patrocinadores');
        $p = new Paginate('Patrocinadores', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('nome', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Patrocinadores', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Patrocinadores
    # renderiza a visão /view/Patrocinadores/view.php
    function view(){
        try {
            $this->set('Patrocinadores', new Patrocinadores((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Patrocinadores', 'all');
        }
    }

    # formulário de cadastro de Patrocinadores
    # renderiza a visão /view/Patrocinadores/add.php
    function add(){
        $this->setTitle('Adicionar Patrocinadores');
        $this->set('Patrocinadores', new Patrocinadores);
        $this->set('Tipopatrocinadores',  Tipopatrocinador::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Patrocinadores
    # (true)redireciona ou (false) renderiza a visão /view/Patrocinadores/add.php
    function post_add(){
        $this->setTitle('Adicionar Patrocinadores');
        $Patrocinadores = new Patrocinadores();
        $this->set('Patrocinadores', $Patrocinadores);
        try {
            if($Patrocinadores->save($_POST)){
                if (!empty($_FILES['imagem']['name'])) {
                    $img = $_FILES['imagem'];
                    $Imagem = new ImageUploader($img, 154);
                    $path = "/patrocinadores/" . $Patrocinadores->id;
                    $nome = time() . $img['name'];
                    if ($Imagem->save($nome, $path)) {
                        $Prog = new Patrocinadores($Patrocinadores->id);
                        $Prog->imagem = $path . "/" . $nome;
                        $Prog->save();
                    }
                }
            }
            new Msg(__('Patrocinadores cadastrado com sucesso'));
            $this->go('Patrocinadores', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Tipopatrocinadores',  Tipopatrocinador::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Patrocinadores
    # renderiza a visão /view/Patrocinadores/edit.php
    function edit(){
        $this->setTitle('Editar Patrocinadores');
        try {
            $this->set('Patrocinadores', new Patrocinadores((int) $this->getParam('id')));
            $this->set('Tipopatrocinadores',  Tipopatrocinador::getList());
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Patrocinadores', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Patrocinadores
    # (true)redireciona ou (false) renderiza a visão /view/Patrocinadores/edit.php
    function post_edit(){
        $this->setTitle('Editar Patrocinadores');
        try {
            $Patrocinadores = new Patrocinadores((int) $_POST['id']);
            $this->set('Patrocinadores', $Patrocinadores);
            if($Patrocinadores->save($_POST)){
                if (!empty($_FILES['imagem']['name'])) {
                    $img = $_FILES['imagem'];
                    $Imagem = new ImageUploader($img, 354);
                    $path = "/patrocinadores/" . $_POST['id'];
                    $nome = time() . $img['name'];
                    if ($Imagem->save($nome, $path)) {
                        $Prod = new Patrocinadores($_POST['id']);
                        $Prod->imagem = $path . "/" . $nome;
                        $Prod->save();
                    }
                }
            }
            new Msg(__('Patrocinadores atualizado com sucesso'));
            $this->go('Patrocinadores', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Tipopatrocinadores',  Tipopatrocinador::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Patrocinadores
    # renderiza a /view/Patrocinadores/delete.php
    function delete(){
        $this->setTitle('Apagar Patrocinadores');
        try {
            $this->set('Patrocinadores', new Patrocinadores((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Patrocinadores', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Patrocinadores
    # redireciona para Patrocinadores/all
    function post_delete(){
        try {
            $Patrocinadores = new Patrocinadores((int) $_POST['id']);
            $Patrocinadores->delete();
            new Msg(__('Patrocinadores apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Patrocinadores', 'all');
    }

}