<?php
final class SituacaotrabalhoController extends AppController{ 

    # página inicial do módulo Situacaotrabalho
    function index(){
        $this->setTitle('Situacaotrabalho');
    }

    # lista de Situacaotrabalhos
    # renderiza a visão /view/Situacaotrabalho/all.php
    function all(){
        $this->setTitle('Situacaotrabalhos');
        $p = new Paginate('Situacaotrabalho', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('titulo', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Situacaotrabalhos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Situacaotrabalho
    # renderiza a visão /view/Situacaotrabalho/view.php
    function view(){
        try {
            $this->set('Situacaotrabalho', new Situacaotrabalho((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Situacaotrabalho', 'all');
        }
    }

    # formulário de cadastro de Situacaotrabalho
    # renderiza a visão /view/Situacaotrabalho/add.php
    function add(){
        $this->setTitle('Adicionar Situacaotrabalho');
        $this->set('Situacaotrabalho', new Situacaotrabalho);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Situacaotrabalho
    # (true)redireciona ou (false) renderiza a visão /view/Situacaotrabalho/add.php
    function post_add(){
        $this->setTitle('Adicionar Situacaotrabalho');
        $Situacaotrabalho = new Situacaotrabalho();
        $this->set('Situacaotrabalho', $Situacaotrabalho);
        try {
            $Situacaotrabalho->save($_POST);
            new Msg(__('Situacaotrabalho cadastrado com sucesso'));
            $this->go('Situacaotrabalho', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Situacaotrabalho
    # renderiza a visão /view/Situacaotrabalho/edit.php
    function edit(){
        $this->setTitle('Editar Situacaotrabalho');
        try {
            $this->set('Situacaotrabalho', new Situacaotrabalho((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Situacaotrabalho', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Situacaotrabalho
    # (true)redireciona ou (false) renderiza a visão /view/Situacaotrabalho/edit.php
    function post_edit(){
        $this->setTitle('Editar Situacaotrabalho');
        try {
            $Situacaotrabalho = new Situacaotrabalho((int) $_POST['id']);
            $this->set('Situacaotrabalho', $Situacaotrabalho);
            $Situacaotrabalho->save($_POST);
            new Msg(__('Situacaotrabalho atualizado com sucesso'));
            $this->go('Situacaotrabalho', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Situacaotrabalho
    # renderiza a /view/Situacaotrabalho/delete.php
    function delete(){
        $this->setTitle('Apagar Situacaotrabalho');
        try {
            $this->set('Situacaotrabalho', new Situacaotrabalho((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Situacaotrabalho', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Situacaotrabalho
    # redireciona para Situacaotrabalho/all
    function post_delete(){
        try {
            $Situacaotrabalho = new Situacaotrabalho((int) $_POST['id']);
            $Situacaotrabalho->delete();
            new Msg(__('Situacaotrabalho apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Situacaotrabalho', 'all');
    }

}