<?php
final class TipoeventoController extends AppController{ 

    # página inicial do módulo Tipoevento
    function index(){
        $this->setTitle('Tipoevento');
    }

    # lista de Tipoeventos
    # renderiza a visão /view/Tipoevento/all.php
    function all(){
        $this->setTitle('Tipoeventos');
        $p = new Paginate('Tipoevento', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('titulo', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Tipoeventos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Tipoevento
    # renderiza a visão /view/Tipoevento/view.php
    function view(){
        try {
            $this->set('Tipoevento', new Tipoevento((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Tipoevento', 'all');
        }
    }

    # formulário de cadastro de Tipoevento
    # renderiza a visão /view/Tipoevento/add.php
    function add(){
        $this->setTitle('Adicionar Tipoevento');
        $this->set('Tipoevento', new Tipoevento);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Tipoevento
    # (true)redireciona ou (false) renderiza a visão /view/Tipoevento/add.php
    function post_add(){
        $this->setTitle('Adicionar Tipoevento');
        $Tipoevento = new Tipoevento();
        $this->set('Tipoevento', $Tipoevento);
        try {
            $Tipoevento->save($_POST);
            new Msg(__('Tipoevento cadastrado com sucesso'));
            $this->go('Tipoevento', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Tipoevento
    # renderiza a visão /view/Tipoevento/edit.php
    function edit(){
        $this->setTitle('Editar Tipoevento');
        try {
            $this->set('Tipoevento', new Tipoevento((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Tipoevento', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Tipoevento
    # (true)redireciona ou (false) renderiza a visão /view/Tipoevento/edit.php
    function post_edit(){
        $this->setTitle('Editar Tipoevento');
        try {
            $Tipoevento = new Tipoevento((int) $_POST['id']);
            $this->set('Tipoevento', $Tipoevento);
            $Tipoevento->save($_POST);
            new Msg(__('Tipoevento atualizado com sucesso'));
            $this->go('Tipoevento', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Tipoevento
    # renderiza a /view/Tipoevento/delete.php
    function delete(){
        $this->setTitle('Apagar Tipoevento');
        try {
            $this->set('Tipoevento', new Tipoevento((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Tipoevento', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Tipoevento
    # redireciona para Tipoevento/all
    function post_delete(){
        try {
            $Tipoevento = new Tipoevento((int) $_POST['id']);
            $Tipoevento->delete();
            new Msg(__('Tipoevento apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Tipoevento', 'all');
    }

}