<?php
final class TipopatrocinadorController extends AppController{ 

    # página inicial do módulo Tipopatrocinador
    function index(){
        $this->setTitle('Tipopatrocinador');
    }

    # lista de Tipopatrocinadores
    # renderiza a visão /view/Tipopatrocinador/all.php
    function all(){
        $this->setTitle('Tipopatrocinadores');
        $p = new Paginate('Tipopatrocinador', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('nome', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Tipopatrocinadores', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Tipopatrocinador
    # renderiza a visão /view/Tipopatrocinador/view.php
    function view(){
        try {
            $this->set('Tipopatrocinador', new Tipopatrocinador((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Tipopatrocinador', 'all');
        }
    }

    # formulário de cadastro de Tipopatrocinador
    # renderiza a visão /view/Tipopatrocinador/add.php
    function add(){
        $this->setTitle('Adicionar Tipopatrocinador');
        $this->set('Tipopatrocinador', new Tipopatrocinador);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Tipopatrocinador
    # (true)redireciona ou (false) renderiza a visão /view/Tipopatrocinador/add.php
    function post_add(){
        $this->setTitle('Adicionar Tipopatrocinador');
        $Tipopatrocinador = new Tipopatrocinador();
        $this->set('Tipopatrocinador', $Tipopatrocinador);
        try {
            $Tipopatrocinador->save($_POST);
            new Msg(__('Tipopatrocinador cadastrado com sucesso'));
            $this->go('Tipopatrocinador', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Tipopatrocinador
    # renderiza a visão /view/Tipopatrocinador/edit.php
    function edit(){
        $this->setTitle('Editar Tipopatrocinador');
        try {
            $this->set('Tipopatrocinador', new Tipopatrocinador((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Tipopatrocinador', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Tipopatrocinador
    # (true)redireciona ou (false) renderiza a visão /view/Tipopatrocinador/edit.php
    function post_edit(){
        $this->setTitle('Editar Tipopatrocinador');
        try {
            $Tipopatrocinador = new Tipopatrocinador((int) $_POST['id']);
            $this->set('Tipopatrocinador', $Tipopatrocinador);
            $Tipopatrocinador->save($_POST);
            new Msg(__('Tipopatrocinador atualizado com sucesso'));
            $this->go('Tipopatrocinador', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Tipopatrocinador
    # renderiza a /view/Tipopatrocinador/delete.php
    function delete(){
        $this->setTitle('Apagar Tipopatrocinador');
        try {
            $this->set('Tipopatrocinador', new Tipopatrocinador((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Tipopatrocinador', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Tipopatrocinador
    # redireciona para Tipopatrocinador/all
    function post_delete(){
        try {
            $Tipopatrocinador = new Tipopatrocinador((int) $_POST['id']);
            $Tipopatrocinador->situacao=4;
            $Tipopatrocinador->save();
            new Msg(__('Tipopatrocinador apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Tipopatrocinador', 'all');
    }

}