<?php
final class TrabalhosController extends AppController{ 

    # página inicial do módulo Trabalhos
    function index(){
        $this->setTitle('Trabalhos');
    }

    # lista de Trabalhos
    # renderiza a visão /view/Trabalhos/all.php
    function all(){
        $this->setTitle('Trabalhos');
        $p = new Paginate('Trabalhos', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('titulo', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Trabalhos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Trabalhos
    # renderiza a visão /view/Trabalhos/view.php
    function view(){
        try {
            $this->set('Trabalhos', new Trabalhos((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Trabalhos', 'all');
        }
    }

    # formulário de cadastro de Trabalhos
    # renderiza a visão /view/Trabalhos/add.php
    function add(){
        $this->setTitle('Adicionar Trabalhos');
        $this->set('Trabalhos', new Trabalhos);
        $this->set('Areas',  Area::getList());
        $this->set('Inscricaos',  Inscricao::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Trabalhos
    # (true)redireciona ou (false) renderiza a visão /view/Trabalhos/add.php
    function post_add(){
        $this->setTitle('Adicionar Trabalhos');
        $Trabalhos = new Trabalhos();
        $this->set('Trabalhos', $Trabalhos);
        try {
            $Trabalhos->save($_POST);
            new Msg(__('Trabalhos cadastrado com sucesso'));
            $this->go('Trabalhos', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Areas',  Area::getList());
        $this->set('Inscricaos',  Inscricao::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Trabalhos
    # renderiza a visão /view/Trabalhos/edit.php
    function edit(){
        $this->setTitle('Editar Trabalhos');
        try {
            $this->set('Trabalhos', new Trabalhos((int) $this->getParam('id')));
            $this->set('Areas',  Area::getList());
            $this->set('Inscricaos',  Inscricao::getList());
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Trabalhos', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Trabalhos
    # (true)redireciona ou (false) renderiza a visão /view/Trabalhos/edit.php
    function post_edit(){
        $this->setTitle('Editar Trabalhos');
        try {
            $Trabalhos = new Trabalhos((int) $_POST['id']);
            $this->set('Trabalhos', $Trabalhos);
            $Trabalhos->save($_POST);
            new Msg(__('Trabalhos atualizado com sucesso'));
            $this->go('Trabalhos', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Areas',  Area::getList());
        $this->set('Inscricaos',  Inscricao::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Trabalhos
    # renderiza a /view/Trabalhos/delete.php
    function delete(){
        $this->setTitle('Apagar Trabalhos');
        try {
            $this->set('Trabalhos', new Trabalhos((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Trabalhos', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Trabalhos
    # redireciona para Trabalhos/all
    function post_delete(){
        try {
            $Trabalhos = new Trabalhos((int) $_POST['id']);
            $Trabalhos->delete();
            new Msg(__('Trabalhos apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Trabalhos', 'all');
    }

}