<?php
final class UsuariosController extends AppController{ 

    # página inicial do módulo Usuarios
    function index(){
        $this->setTitle('Usuarios');
    }

    # lista de Usuarios
    # renderiza a visão /view/Usuarios/all.php
    function all(){
        $this->setTitle('Usuarios');
        $p = new Paginate('Usuarios', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('nome', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Usuarios', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Usuarios
    # renderiza a visão /view/Usuarios/view.php
    function view(){
        try {
            $this->set('Usuarios', new Usuarios((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Usuarios', 'all');
        }
    }

    # formulário de cadastro de Usuarios
    # renderiza a visão /view/Usuarios/add.php
    function add(){
        $this->setTitle('Adicionar Usuarios');
        $this->set('Usuarios', new Usuarios);
        $this->set('Situacaos',  Situacao::getList());
        $this->set('Grupos',  Grupo::getList());
    }

    # recebe os dados enviados via post do cadastro de Usuarios
    # (true)redireciona ou (false) renderiza a visão /view/Usuarios/add.php
    function post_add(){
        $this->setTitle('Adicionar Usuarios');
        $Usuarios = new Usuarios();
        $this->set('Usuarios', $Usuarios);
        try {
            $_POST['senha'] = md5(Config::get('salt').$_POST['senha']);
            $Usuarios->save($_POST);
            new Msg(__('Usuarios cadastrado com sucesso'));
            $this->go('Usuarios', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
        $this->set('Grupos',  Grupo::getList());
    }

    # formulário de edição de Usuarios
    # renderiza a visão /view/Usuarios/edit.php
    function edit(){
        $this->setTitle('Editar Usuarios');
        try {
            $this->set('Usuarios', new Usuarios((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
            $this->set('Grupos',  Grupo::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Usuarios', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Usuarios
    # (true)redireciona ou (false) renderiza a visão /view/Usuarios/edit.php
    function post_edit(){
        $this->setTitle('Editar Usuarios');
        try {
            $Usuarios = new Usuarios((int) $_POST['id']);
            $this->set('Usuarios', $Usuarios);
            $Usuarios->save($_POST);
            new Msg(__('Usuarios atualizado com sucesso'));
            $this->go('Usuarios', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
        $this->set('Grupos',  Grupo::getList());
    }

    # Confirma a exclusão ou não de um(a) Usuarios
    # renderiza a /view/Usuarios/delete.php
    function delete(){
        $this->setTitle('Apagar Usuarios');
        try {
            $this->set('Usuarios', new Usuarios((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Usuarios', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Usuarios
    # redireciona para Usuarios/all
    function post_delete(){
        try {
            $Usuarios = new Usuarios((int) $_POST['id']);
            $Usuarios->situacao=4;
            $Usuarios->save();
            new Msg(__('Usuarios apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Usuarios', 'all');
    }

    function loginUnico(){
        $c = new Criteria();
        $c->addCondition('login','=',$_POST['login']);
        $login = Usuarios::getList($c);
        $res = 0;
        if(count($login)>0){
            $res = 1;
        }
        echo $res;
        exit;
    }
    function loginUnicoEditar(){
        $c = new Criteria();
        $c->addCondition('login','=',$_POST['login']);
        $c->addCondition('id','<>',$_POST['id']);
        $login = Usuarios::getList($c);
        $res = 0;
        if(count($login)>0){
            $res = 1;
        }
        echo $res;
        exit;
    }

}