<?php
final class Imagensturismo extends Record{ 

    const TABLE = 'imagensturismo';
    const PK = 'id';
    
    /**
    * Configurações e filtros globais do modelo
    * @return Criteria $criteria
    */
    public static function configure(){
        $criteria = new Criteria();
        $criteria->addCondition('situacao','<>',4);
        return $criteria;
    }
    
    /**
    * Imagensturismo pertence a Turismo
    * @return Turismo $Turismo
    */
    function getTurismo() {
        return $this->belongsTo('Turismo','id_turismo');
    }
    
    /**
    * Imagensturismo pertence a Situacao
    * @return Situacao $Situacao
    */
    function getSituacao() {
        return $this->belongsTo('Situacao','situacao');
    }
}