<?php
final class Inscricao extends Record{ 

    const TABLE = 'inscricao';
    const PK = 'id';
    
    /**
    * Configurações e filtros globais do modelo
    * @return Criteria $criteria
    */
    public static function configure(){
        /*$criteria = new Criteria();
        $criteria->addCondition('situacao','<>',3);
        return $criteria;*/
    }
    
    /**
    * Inscricao pertence a Formapg
    * @return Formapg $Formapg
    */
    function getFormapg() {
        return $this->belongsTo('Formapg','formapg');
    }
    
    /**
    * Inscricao pertence a Situacao
    * @return Situacao $Situacao
    */
    function getSituacao() {
        return $this->belongsTo('Situacao','situacao');
    }
    
    /**
    * Inscricao pertence a Grupos
    * @return Grupos $Grupos
    */
    function getGrupos() {
        return $this->belongsTo('Grupos','grupo');
    }
    
    /**
    * Inscricao possui Trabalhos
    * @return array de Trabalhos
    */
    function getTrabalhos($criteria=NULL) {
        return $this->hasMany('Trabalhos','idAluno',$criteria);
    }
}