<?php
final class Programacao extends Record{ 

    const TABLE = 'programacao';
    const PK = 'id';
    
    /**
    * Configurações e filtros globais do modelo
    * @return Criteria $criteria
    */
    public static function configure(){
        # $criteria = new Criteria();
        # return $criteria;
    }
    
    /**
    * Programacao pertence a Data_programacao
    * @return Data_programacao $Data_programacao
    */
    function getData_programacao() {
        return $this->belongsTo('Data_programacao','iddata');
    }
    
    /**
    * Programacao pertence a Tipoevento
    * @return Tipoevento $Tipoevento
    */
    function getTipoevento() {
        return $this->belongsTo('Tipoevento','tipoEvento');
    }
    
    /**
    * Programacao pertence a Situacao
    * @return Situacao $Situacao
    */
    function getSituacao() {
        return $this->belongsTo('Situacao','situacao');
    }
    
    /**
    * Programacao pertence a Palestrante
    * @return Palestrante $Palestrante
    */
    function getPalestrante() {
        return $this->belongsTo('Palestrante','palestrante');
    }
}