<?php
final class Tipopatrocinador extends Record{ 

    const TABLE = 'tipopatrocinador';
    const PK = 'id';
    
    /**
    * Configurações e filtros globais do modelo
    * @return Criteria $criteria
    */
    public static function configure(){
        $criteria = new Criteria();
        $criteria->addCondition('situacao','<>',4);
        return $criteria;
    }
    
    /**
    * Tipopatrocinador possui Patrocinadores
    * @return array de Patrocinadores
    */
    function getPatrocinadores($criteria=NULL) {
        return $this->hasMany('Patrocinadores','tipoPatrocinador',$criteria);
    }
    
    /**
    * Tipopatrocinador pertence a Situacao
    * @return Situacao $Situacao
    */
    function getSituacao() {
        return $this->belongsTo('Situacao','situacao');
    }
}