<?php
final class Turismo extends Record{ 

    const TABLE = 'turismo';
    const PK = 'id';
    
    /**
    * Configurações e filtros globais do modelo
    * @return Criteria $criteria
    */
    public static function configure(){
        $criteria = new Criteria();
        $criteria->addCondition('situacao','<>',4);
        return $criteria;
    }
    
    /**
    * Turismo possui Imagensturismos
    * @return array de Imagensturismos
    */
    function getImagensturismos($criteria=NULL) {
        return $this->hasMany('Imagensturismo','id_turismo',$criteria);
    }
    
    /**
    * Turismo pertence a Situacao
    * @return Situacao $Situacao
    */
    function getSituacao() {
        return $this->belongsTo('Situacao','situacao');
    }
}