<?php
final class InscricaoController extends AppController{ 

    # página inicial do módulo Inscricao
    function index(){
        $this->setTitle('Visualização de Inscrição');
    }

    # lista de Inscricaos
    # renderiza a visão /view/Inscricao/all.php
    function all(){
        $user = Session::get('userGrupos');
        $this->setTitle('Listagem de Inscrições');
        $p = new Paginate('Inscricao', 10);
        $c = new Criteria();
        $situacao=1;
        if(!empty($_POST["filtro"])){
            if(!empty($_POST["filtro"]["interno"])){
                foreach($_POST["filtro"]["interno"] as $fl => $fv ){
                    $this->setParam($fl,$fv);
                    if(!empty($fv)){
                        $c->addCondition($fl, "LIKE", "%" . $fv . "%");
                    }
                }
            }

            if(!empty($_POST["filtro"]["externo"])){
                foreach($_POST["filtro"]["externo"] as $fl => $fv ){
                    $this->setParam($fl,$fv);
                    if(!empty($fv)){
                        $this->set($fl,$fv);
                        if($fl=='situacao'){
                            $situacao=$fv;
                        }
                        if($fv!='all')
                        $c->addCondition($fl, "=", $fv);
                    }
                }
            }
        }

        $this->set('situacao',$situacao);

        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $c->addCondition('grupo','=',$user->id);
        $this->set('Inscricaos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    

        $this->set('Categoriainscricaos',  Categoriainscricao::getList());
        $this->set('Situacaos',  Situacao::getList());
        $this->set('Grupos',  Grupos::getList());
    

    }

    function viewall(){
        $user = Session::get('userIndividual');
        $this->setTitle('Listagem de Inscrições');
        $p = new Paginate('Inscricao', 10);
        $c = new Criteria();
        if(!empty($_POST["filtro"])){
            if(!empty($_POST["filtro"]["interno"])){
                foreach($_POST["filtro"]["interno"] as $fl => $fv ){
                    $this->setParam($fl,$fv);
                    if(!empty($fv)){
                        $c->addCondition($fl, "LIKE", "%" . $fv . "%");
                    }
                }
            }
            if(!empty($_POST["filtro"]["externo"])){
                foreach($_POST["filtro"]["externo"] as $fl => $fv ){
                    $this->setParam($fl,$fv);
                    if(!empty($fv)){
                        $c->addCondition($fl, "=", $fv);
                    }
                }
            }
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $c->addCondition('id','=',$user->id);
        $this->set('Inscricaos', $p->getPage($c));
        $this->set('nav', $p->getNav());


        $this->set('Categoriainscricaos',  Categoriainscricao::getList());
        $this->set('Situacaos',  Situacao::getList());
        $this->set('Grupos',  Grupos::getList());


    }

    # visualiza um(a) Inscricao
    # renderiza a visão /view/Inscricao/view.php
    function view(){
        $this->setTitle('Visualização de Inscrição');
        try {
            $this->set('Inscricao', new Inscricao((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Inscricao', 'all');
        }
    }

    # formulário de cadastro de Inscricao
    # renderiza a visão /view/Inscricao/add.php
    function add(){
        $this->setTitle('Cadastro de Inscrição');
        $this->set('Inscricao', new Inscricao);
        $this->set('FormaPagamento',  Formapg::getList());
        $this->set('Categoriainscricaos',  Categoriainscricao::getList());
        $this->set('Situacaos',  Situacao::getList());
        $this->set('Grupos',  Grupos::getList());
    }

    # recebe os dados enviados via post do cadastro de Inscricao
    # (true)redireciona ou (false) renderiza a visão /view/Inscricao/add.php
    function post_add(){
        
        $this->setTitle('Cadastro de Inscrição');
        $Inscricao = new Inscricao();
        $this->set('Inscricao', $Inscricao);
        try {
            $user = Session::get('userGrupos');
            $_POST['datahora_inscricao'] = date('Y-m-d H:i:s');
            $_POST['quem_cadastro'] = $user->id;

            if($Inscricao->save($_POST)){
                $grupo = new Grupos((int)$_POST['grupo']);
                $grupo->qtdeInscritos =  $grupo->qtdeInscritos+1;
                $grupo->save();
                new Msg(__('Inscrição realizada com sucesso! '));
                if(!empty($_POST['sub'])){
                    Session::set('userIndividual',$Inscricao);
                    $this->go('Inscricao', 'viewall');
                    exit;
                }
//                $this->EnviarEmail($_POST['email'],$_POST['nome'],$_POST['login'],$senha);
            }
            $this->go('Inscricao', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Categoriainscricaos',  Categoriainscricao::getList());
        $this->set('Situacaos',  Situacao::getList());
        $this->set('Grupos',  Grupos::getList());
    }

    # formulário de edição de Inscricao
    # renderiza a visão /view/Inscricao/edit.php
    function edit(){
        $this->setTitle('Edição de Inscrição');
        try {
            $this->set('Inscricao', new Inscricao((int) $this->getParam('id')));
            $this->set('Categoriainscricaos',  Categoriainscricao::getList());
            $this->set('FormaPagamento',  Formapg::getList());

            $this->set('Situacaos',  Situacao::getList());
            $this->set('Grupos',  Grupos::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Inscricao', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Inscricao
    # (true)redireciona ou (false) renderiza a visão /view/Inscricao/edit.php
    function post_edit(){
        $this->setTitle('Edição de Inscrição');
        try {
            $Inscricao = new Inscricao((int) $_POST['id']);
            $this->set('Inscricao', $Inscricao);
            $user = Session::get('userGrupos');
            $_POST['ultima_data'] = date('Y-m-d H:i:s');
            $_POST['ultimo_id'] = $user->id;
            $Inscricao->save($_POST);
            new Msg(__('Inscricao atualizado com sucesso'));
            if(!empty($_POST['individual']))
                $this->go('Inscricao', 'viewall');
            else
                $this->go('Inscricao', 'all');

        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Categoriainscricaos',  Categoriainscricao::getList());
        $this->set('Situacaos',  Situacao::getList());
        $this->set('Grupos',  Grupos::getList());
    }

    # Confirma a exclusão ou não de um(a) Inscricao
    # renderiza a /view/Inscricao/delete.php
    function delete(){
        $this->setTitle('Apagar Inscricao');
        try {
            $this->set('Inscricao', new Inscricao((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Inscricao', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Inscricao
    # redireciona para Inscricao/all
    function post_delete(){
        try {
            $Inscricao = new Inscricao((int) $_POST['id']);
            $Inscricao->situacao=3;
            if($Inscricao->save()) {
                $grupo = new Grupos((int)$_POST['grupo']);
                $grupo->qtdeInscritos = $grupo->qtdeInscritos - 1;
                $grupo->save();
            }
            new Msg(__('Inscrição apagada com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Inscricao', 'all');
    }

    function resetarSenha() {
        $this->setTitle('Resetar Senha');
        try {
            $this->set('Inscricao', new Inscricao((int) $this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Inscricao', 'all');
        }
    }

    function post_resetarSenha() {
        $this->setTitle('Resetar Senha');
        try {
            $a = new Inscricao($_POST['id']);
            $a->senha = md5(Config::get('salt') . '12345');
            if ($a->save()) {
                new Msg("Senha Resetada com sucesso! Nova senha: 12345", 1);
            }
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Inscricao', 'all');
        }
        $this->go('Inscricao', 'all');
    }

    function cep(){
        $cep = $_POST['cep'];
        $url =  "http://cep.republicavirtual.com.br/web_cep.php?formato=xml&cep=" . $cep;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_URL,$url);
        $aux = curl_exec($ch);
        curl_close($ch);
        $dados = simplexml_load_string($aux);
        echo $dados->resultado.",".$dados->logradouro.",".$dados->bairro.",".$dados->cidade.",".$dados->uf;
        exit();
    }

    function AlterarSenha(){
        $user = Session::get('userGrupos');
        $_POST['senha'] = md5( Config::get('salt'). $_POST['senha'] );

        $this->setTitle('Editar Senha');
        $Grupos = new Grupos((int)$_POST['id']);
        $Grupos->status = 1;
        if($Grupos->save($_POST)){
            $user->status = 1;
            Session::set('userGrupos',$user);
            echo 1;
        }else{
            echo 'erro';
        }
        exit;
    }

    function EnviarEmail($email,$nome,$login,$senha){
        $mail = new PHPMailer();
        $mail->IsSMTP(); // Define que a mensagem será SMTP
        $mail->Host = "vps.chiesaonline.com.br";
        $mail->SMTPAuth = true;
        $mail->Username = 'contato@chiesaonline.com.br';
        $mail->Password = 'chiesa6990';
        $mail->From = "contato@chiesaonline.com.br";
        $mail->FromName = "Chiesa Advogados Associados";

        $mail->AddAddress($email, $nome);
        $mail->AddAddress("contato@chiesaonline.com.br", 'Copia Cadastro do '.$nome);
        $mail->AddAddress("assistente@chiesa.adv.br", 'Copia Cadastro do '.$nome);

        $mail->IsHTML(true);
        $mail->CharSet = 'UTF-8';
//          Texto e Assunto
        $mail->Subject = "Cadastro no Congresso"; // Assunto da mensagem
        $mail->Body = '<table>';
        $mail->Body .= '<tr>';
        $mail->Body = '<td colspan="3"><IMG src="http://chiesaonline.com.br/congresso/template/ucdb/img/logo.png" alt="Congresso Direito Tributário" class="wp-smiley" style="margin-bottom: 20px"><td>';
        $mail->Body .= '</tr>';
        $mail->Body .= '<tr>';
        $mail->Body .= '<td colspan="3"><br /><p><strong>Ol&aacute; '.$nome.'!</strong></p></td>';
        $mail->Body .= '</tr>';
        $mail->Body .= '<tr>';
        $mail->Body .= '<td colspan="3"><p>Seu cadastro no XII Congresso de Direito Tributário foi realizado com sucesso! <br /> Segue abaixo os dados de acesso ao seu painel:</p></td>';
        $mail->Body .= '</tr>';
        $mail->Body .= '<tr>';
        $mail->Body .= '<td colspan="3"><p>Link: <strong>http://chiesaonline.com.br/congresso/grupos/Login/sub/</strong></p></td>';
        $mail->Body .= '<td colspan="3"><p>Login: <strong>'.$login.'</strong><br />Senha: <strong>'.$senha.'</strong></p></td>';
        $mail->Body .= '</tr>';
        $mail->Body .= '</table>';
//            Anexos (opcional)
//            $mail->AddAttachment("e:\home\login\web\documento.pdf", "novo_nome.pdf");

        $enviado = $mail->Send();
//            Limpa os destinatários e os anexos
        $mail->ClearAllRecipients();
        $mail->ClearAttachments();
    }

    function tratarArquivo($string){
        // pegando a extensao do arquivo
        $partes 	= explode(".", $string);
        $extensao 	= $partes[count($partes)-1];
        // somente o nome do arquivo
        $nome	= preg_replace('/\.[^.]*$/', '', $string);
        // removendo simbolos, acentos etc
        $a = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûüýýþÿŔŕ?';
        $b = 'aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuuyybyRr-';
        $nome = strtr($nome, utf8_decode($a), $b);
        $nome = str_replace(".","-",$nome);
        $nome = preg_replace( "/[^0-9a-zA-Z\.]+/",'-',$nome);
        return utf8_decode(strtolower($nome.".".$extensao));
    }

    function certificado(){
        $this->setTitle('Emitir certificado');
        $Inscricao = new Inscricao($this->getParam('id'));
        $this->set('Grupo',$Inscricao->getGrupos());
        $this->set('Inscricao',$Inscricao);
    }

    function imprimir(){
        $Inscricao = new Inscricao((int)$_POST['id']);
        $Inscricao->certificadoemitido = date('Y-m-d H:i:s');
        $Inscricao->impressa= 1;
        if($Inscricao->save()){
            echo 1;
        }else{
            echo 'erro';
        }
        exit;
    }
}