<?php 
/**
 * classe Criteria
 * 
 * @author Miguel
 * @package \lib\core
 */
class Criteria{
	private $conditions = array();
	private $limit;
	private $order;
        public $locked = false;

                /**
         * Adiciona um filtro ao se buscar uma instancia ou coleção de Models. 
         * 
         * Exemplo: buscar uma coleção com filtros:
         * 
         * $c = new Criteria();<br>
         * $c->addCondition('foo', '=' 'teste');<br>
         * $c->addCondition('bar', '>' 5);<br>
         * $arr = Model::getList($c);<br>
         * 
         * o exemplo acima resultará na consulta SQL:<br>
         * SELECT * FROM model WHERE foo = 'teste' AND bar > 5;
         * 
         * @param String $field
         * @param String $op
         * @param String $value
         */
	public function addCondition($field='', $op='=', $value='' ){
		$this->conditions[] = array($field, $op, $value, $field.uniqid());
	}
        
         /**
         * Adiciona um OR entre os filtros ao se buscar uma instancia ou coleção de Models. 
         * 
         * Exemplo: buscar uma coleção com filtros:
         * 
         * $c = new Criteria();<br>
         * $c->addCondition('foo', '=' 'teste');<br>
         * $c->addCondition('bar', '>' 5);<br>
         * $c->addOr();<br>
         * $c->addCondition('y', '>' 0);<br>
         * $arr = Model::getList($c);<br>
         * 
         * o exemplo acima resultará na consulta SQL:<br>
         * SELECT * FROM model WHERE (foo = 'teste' AND bar > 5) OR (y > 0);         * 
         */
        public function addOr(){
            $this->conditions[] = ') OR (';
        }

        /**
         * Define um limite de resultados ao retornar uma coleção de Models
         * 
         * @param int $l
         */
        public function setLimit($number){
		$this->limit = $number;
	}
	
        /**
         * Define a ordenação dos resultados ao retornar uma coleção de Models.
         * 
         * Exemplo: buscar uma coleção ordenada por um campo:
         * 
         * $c = new Criteria();<br>
         * $c->setOrder('foo');<br>
         * $arr = Model::getList($c);<br>
         * 
         * o exemplo acima resultará na consulta SQL:<br>
         * SELECT * FROM model ORDER BY foo;         * 
         * 
         * @param String $o
         */
	public function setOrder($field){
		$this->order = $field;
	}
        
        /**
         * Unifica duas instancias de Criteria
         * @param Criteria $criteria
         */
        public function merge(Criteria $criteria){
            $this->conditions = array_merge($criteria->conditions, $this->conditions);
            if(empty($this->limit))
                $this->limit = $criteria->limit;
            if(empty($this->order))
                $this->order = $criteria->order;
        }
	
	public function getConditions(){
            if(!is_array(reset($this->conditions))){
                array_shift($this->conditions);
            }
            if(!is_array(end($this->conditions))){
                array_pop($this->conditions);
            }
	return $this->conditions;
	}
	
	public function getLimit(){
		return $this->limit;
	}
	
	public function getOrder(){
		return $this->order;
	}	
}
?>