<?php
use Migrations\AbstractMigration;

class CreateTabelaFiliado extends AbstractMigration
{
    /**
     * Change Method.
     *
     * More information on this method is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     * @return void
     */
    public function change()
    {

        if (!$this->hasTable('filiado')) {
            $table = $this->table('filiado');
            
            $table->addColumn('nome', 'string', ['null' => true, 'comment' => 'Nome do Eleitor', 'limit' => 200]);
            $table->addColumn('cpf', 'string', ['null' => true, 'comment' => 'CPF do Eleitor', 'limit' => 30]);
            $table->addColumn('dtnascimento', 'date', ['null' => true, 'comment' => 'Data de Nascimento do Eleitor']);
            $table->addColumn('telefone', 'string', ['null' => true, 'comment' => 'Telefone do Eleitor', 'limit' => 20]);
            $table->addColumn('chave_filiado_sisfetems', 'integer', ['null' => true, 'comment' => 'Chave de Filiação do Eleitor']);
            $table->addColumn('sindicato_id', 'integer', ['null' => true, 'comment' => 'Id do Sindicato']);
            $table->addColumn('cidade_id', 'integer', ['null' => true, 'comment' => 'Id da cidade']);
            $table->addColumn('origem_cadastro', 'string', ['null' => true, 'comment' => 'Origem do Cadastro', 'limit' => 50]);
            $table->addColumn('tipo_avulso', 'integer', ['null' => true, 'comment' => '0 - NÃO | 1 - SIM']);
            $table->addColumn('votou', 'integer', ['null' => true, 'comment' => '0 - NÃO | 1 - SIM', 'default' => 0]);
            $table->addColumn('votou_dthora', 'datetime', ['null' => true, 'comment' => 'Data e Hora da Votação']);

            $table->create();
        }

    }
}
