<?php

namespace App\Controller;

use App\Controller\AppController;

/**
 * Filiado Controller
 *
 * @property \App\Model\Table\FiliadoTable $Filiado
 *
 * @method \App\Model\Entity\Filiado[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class FiliadoController extends AppController
{
    public $components = ['Filtros'];
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null
     */
    public function index()
    {

        $this->loadModel('Configuracao');

        $config = $this->Configuracao->buscarDataHoraVotacao();
        if(!$config->periodo_votacao){
            return $this->redirect(['controller' => 'filiado', 'action' => 'error']);
        }

        $this->request->getSession()->delete('filiado');

        $cpf = $this->request->getData('cpf');
        $filiado = $this->Filiado->find('all')
            ->contain([
                'Sindicato',
                'Cidade',
                'VotacaoChapasmunicipios',
                'VotacaoChapasregionais',
                'VotacaoFetems'
            ])
            ->where(['cpf' => $cpf])
            ->first();

        if ($this->request->is('post')) {
            if (!empty($filiado)) {
                $this->request->getSession()->write('filiado', $filiado);
                $this->redirect(['action' => 'view', base64_encode(json_encode($filiado))]);
            } else {
                $this->Flash->error(__('CPF não encontrado! Por favor faça o cadastro para continuar'));
                $this->redirect(['action' => 'add', '?' => ['cpf' => $cpf]]);
            }
        }
    }

    /**
     * View method
     *
     * @param string|null $id Filiado id.
     * @return \Cake\Http\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($filiadoUrl = null)
    {

        $this->loadModel('Configuracao');

        $config = $this->Configuracao->buscarDataHoraVotacao();
        if(!$config->periodo_votacao){
            return $this->redirect(['controller' => 'filiado', 'action' => 'error']);
        }

        if(empty($this->request->getSession()->read('filiado'))){
            $this->Flash->error(__('Sessão expirada ou não foi iniciada! Por favor faça login.'));
            $this->redirect(['controller' => 'filiado', 'action' => 'index']);
        }

        $filiado_id = json_decode(base64_decode($filiadoUrl))->id;
        $filiado = $this->Filiado->find('all')
        ->contain([
            'Sindicato',
            'Cidade',
            'VotacaoChapasmunicipios',
            'VotacaoChapasregionais',
            'VotacaoFetems'
            ])
        ->where(['Filiado.id' => $filiado_id])
        ->first();

        if (!empty($filiado) && $filiado->votou == 1) {
            $this->loadModel('VotacaoFetems');
            $ip = $this->VotacaoFetems->find('all')->select(['ip'])->where(['filiado_id' => $filiado_id])->first()->ip;
        }

        try {
            $this->Filiado->get($filiado_id);
        } catch (\Cake\Datasource\Exception\RecordNotFoundException $e) {
            $this->Flash->error(__('Filiado não encontrado no sistema. Por favor, faça seu cadastro ou volte para login.'));
            return $this->redirect(['action' => 'add']);
        }

        $this->set(compact('filiado', 'filiadoUrl', 'ip'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {

        $this->loadModel('Configuracao');

        $config = $this->Configuracao->buscarDataHoraVotacao();
        if(!$config->periodo_votacao){
            return $this->redirect(['controller' => 'filiado', 'action' => 'error']);
        }

        $cpf = $this->request->getQuery('cpf');
        $cidade = $this->Filiado->Cidade->find()
            ->order(['nome' => 'ASC'])
            ->combine('id', 'nome')
            ->toArray();

        $filiado = $this->Filiado->newEntity();
        if ($this->request->is('post')) {
            $cpf = $this->request->getData('cpf');
            $filiadoExiste = $this->Filiado->find('all')->where(['cpf' => $cpf])->first();

            if ($filiadoExiste != []) {
                if($filiadoExiste->nome != $this->request->getData('nome')){
                    $this->set(compact('filiado', 'cidade', 'cpf'));
                    return $this->Flash->error(__('Este filiado já está cadastrado no sistema. Por favor verifique o CPF ou volte para login'));
                } else {
                    $this->request->sessfon()->delete('filiado');
                    $this->request->getSession()->write('filiado', $filiado);
                    $this->Flash->success(__('Inicie sua votação.'));
                    return $this->redirect(['controller' => 'votacao-fetems', 'action' => 'add', base64_encode(json_encode($filiadoExiste))]);
                }
            } else if($filiadoExiste == []){
                $this->request->data['dtnascimento'] = date('Y-m-d', strtotime($this->request->data['dtnascimento']));
                $filiado = $this->Filiado->patchEntity($filiado, $this->request->getData());
                $filiado->tipo_avulso = 1;
                $filiado->votou = 0;
                $save = $this->Filiado->save($filiado);
                if ($save) {
                    $this->request->getSession()->delete('filiado');
                    $this->request->getSession()->write('filiado', $filiado);
                    $this->Flash->success(__('Filiado salvo com sucesso. Agora inicie a votação.'));
                    return $this->redirect(['controller' => 'votacao-fetems', 'action' => 'add', base64_encode(json_encode($save))]);
                }
                $this->Flash->error(__('Erro ao salvar filiado. Por favor tente novamente.'));
            }
        }

        $this->set(compact('filiado', 'cidade', 'cpf'));
    }

    function votacaoConcluida($usuario = null)
    {

        $this->loadModel('Configuracao');

        $config = $this->Configuracao->buscarDataHoraVotacao();
        if(!$config->periodo_votacao){
            return $this->redirect(['controller' => 'filiado', 'action' => 'error']);
        }

        if(empty($this->request->getSession()->read('filiado'))){
            $this->Flash->error(__('Sessão expirada ou não foi iniciada! Por favor faça login.'));
            return $this->redirect(['controller' => 'filiado', 'action' => 'index']);
        }

        $cidade_id = $this->Filiado->getCidadeId($usuario);
        if (!empty($cidade_id)) {
            $id = json_decode(base64_decode($usuario))->id;

            $filiado = $this->Filiado->get($id, [
                'contain' => [],
            ]);

            $this->loadModel('VotacaoFetems');
            $filiado_votou_fetems = $this->VotacaoFetems->find('all')->select(['filiado_id', 'ip'])->where(['filiado_id' => $id])->first();

            $this->loadModel('VotacaoChapasregionais');
            $filiado_votou_regional = $this->VotacaoChapasregionais->find('all')->select(['filiado_id'])->where(['filiado_id' => $id])->first();

            if((!empty($filiado_votou_fetems)) && $filiado->votou == 0){
                $filiado = $this->Filiado->patchEntity($filiado, $this->request->getData());
                $filiado->votou = 1;
                $filiado->votou_dthora = date('Y-m-d H:i:s');
                $this->Filiado->save($filiado);
                $this->request->getSession()->delete('filiado');
            } else {
                $this->Flash->info(__('Seu votó já foi realizado em '. $filiado->votou_dthora.' pelo IP '.$filiado_votou_fetems->ip));
                return $this->redirect(['action' => 'index']);
            }

            $this->set(compact('cidade_id'));
        }
    }

    public function error(){

        $this->loadModel('Configuracao');

        $config = $this->Configuracao->buscarDataHoraVotacao();

        $dthora_atual = $config->dthora_atual;

        $dthora_inicio = $config->dthora_inicio;

        $dthora_fim = $config->dthora_fim;

        $antes_da_votacao = $dthora_atual < $dthora_inicio;

        $depois_da_votacao = $dthora_atual > $dthora_fim;

        if($dthora_inicio > $dthora_fim){

            $periodo_errado = 'ERRO NAS DATAS DE INÍCIO E FIM. CONTATE O ADMINISTRADOR DO SISTEMA.';

        } else {

            if($config->periodo_votacao){
                return $this->redirect(['controller' => 'filiado', 'action' => 'index']);
            }

        }

        $this->set(compact('dthora_atual', 'dthora_inicio', 'dthora_fim', 'antes_da_votacao', 'depois_da_votacao', 'periodo_errado'));

    }
}
