<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Filiado Entity
 *
 * @property int $id
 * @property string|null $nome
 * @property string|null $cpf
 * @property \Cake\I18n\FrozenDate|null $dtnascimento
 * @property string|null $telefone
 * @property int|null $chave_filiado_sisfetems
 * @property int|null $sindicato_id
 * @property int|null $cidade_id
 * @property int|null $origem_cadastro
 * @property int|null $tipo_avulso
 * @property int|null $votou
 * @property \Cake\I18n\FrozenTime|null $votou_dthora
 *
 * @property \App\Model\Entity\Sindicato $sindicato
 * @property \App\Model\Entity\Cidade $cidade
 * @property \App\Model\Entity\VotacaoChapasmunicipio[] $votacao_chapasmunicipios
 * @property \App\Model\Entity\VotacaoChapasregionai[] $votacao_chapasregionais
 * @property \App\Model\Entity\VotacaoFetem[] $votacao_fetems
 */
class Filiado extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'nome' => true,
        'cpf' => true,
        'dtnascimento' => true,
        'telefone' => true,
        'chave_filiado_sisfetems' => true,
        'sindicato_id' => true,
        'cidade_id' => true,
        'origem_cadastro' => true,
        'tipo_avulso' => true,
        'votou' => true,
        'votou_dthora' => true,
        'sindicato' => true,
        'cidade' => true,
        'votacao_chapasmunicipios' => true,
        'votacao_chapasregionais' => true,
        'votacao_fetems' => true,
    ];
}
