<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Filiado Model
 *
 * @property \App\Model\Table\SindicatosTable&\Cake\ORM\Association\BelongsTo $Sindicatos
 * @property \App\Model\Table\CidadesTable&\Cake\ORM\Association\BelongsTo $Cidades
 * @property \App\Model\Table\VotacaoChapasmunicipiosTable&\Cake\ORM\Association\HasMany $VotacaoChapasmunicipios
 * @property \App\Model\Table\VotacaoChapasregionaisTable&\Cake\ORM\Association\HasMany $VotacaoChapasregionais
 * @property \App\Model\Table\VotacaoFetemsTable&\Cake\ORM\Association\HasMany $VotacaoFetems
 *
 * @method \App\Model\Entity\Filiado get($primaryKey, $options = [])
 * @method \App\Model\Entity\Filiado newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Filiado[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Filiado|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Filiado saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Filiado patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Filiado[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Filiado findOrCreate($search, callable $callback = null, $options = [])
 */
class FiliadoTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('filiado');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Sindicato', [
            'foreignKey' => 'sindicato_id',
        ]);
        $this->belongsTo('Cidade', [
            'foreignKey' => 'cidade_id',
        ]);
        $this->hasMany('VotacaoChapasmunicipios', [
            'foreignKey' => 'filiado_id',
        ]);
        $this->hasMany('VotacaoChapasregionais', [
            'foreignKey' => 'filiado_id',
        ]);
        $this->hasMany('VotacaoFetems', [
            'foreignKey' => 'filiado_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 200)
            ->allowEmptyString('nome');

        $validator
            ->scalar('cpf')
            ->maxLength('cpf', 30)
            ->allowEmptyString('cpf');

        $validator
            ->date('dtnascimento')
            ->allowEmptyDate('dtnascimento');

        $validator
            ->scalar('telefone')
            ->maxLength('telefone', 20)
            ->allowEmptyString('telefone');

        $validator
            ->integer('chave_filiado_sisfetems')
            ->allowEmptyString('chave_filiado_sisfetems');

        $validator
            ->integer('origem_cadastro')
            ->allowEmptyString('origem_cadastro');

        $validator
            ->integer('tipo_avulso')
            ->allowEmptyString('tipo_avulso');

        $validator
            ->integer('votou')
            ->allowEmptyString('votou');

        $validator
            ->dateTime('votou_dthora')
            ->allowEmptyDateTime('votou_dthora');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['sindicato_id'], 'Sindicato'));
        $rules->add($rules->existsIn(['cidade_id'], 'Cidade'));

        return $rules;
    }

    public function getCidadeId($filiado)
    {
        $filiado = json_decode(base64_decode($filiado));
        if(!empty($filiado)){
            $usuario_id = $filiado->id;
            $filiado = $this->find('all')->where(['id' => $usuario_id])->first(); 
            return $filiado->cidade_id;
        }
        return null;
    }

    public function getSindicatoId($filiado)
    {
        $filiado = json_decode(base64_decode($filiado));
        if(!empty($filiado)){
            $usuario_id = $filiado->id;
            $filiado = $this->find('all')->where(['id' => $usuario_id])->first(); 
            return $filiado->sindicato_id;
        }
        return null;
    }

    public function filiadoVotouDthoraIp($filiado, $chapa)
    {
        $filiado = json_decode(base64_decode($filiado));
        
        if(!empty($filiado)){
            $usuario_id = $filiado->id;
            $votou = $this->$chapa->find()->select(['ip'])->where(['filiado_id' => $usuario_id])->first();
            if(!empty($votou)){
                unset($filiado->votacao_fetems);
                unset($filiado->votacao_chapasregionais);
                unset($filiado->votacao_chapasmunicipios);
                $votou->filiado = $filiado;
                return $votou;
            }
        }
        return $filiado;
    }
}
