<?php
namespace App\Test\Fixture;

use Cake\TestSuite\Fixture\TestFixture;

/**
 * FiliadoFixture
 */
class FiliadoFixture extends TestFixture
{
    /**
     * Table name
     *
     * @var string
     */
    public $table = 'filiado';
    /**
     * Fields
     *
     * @var array
     */
    // @codingStandardsIgnoreStart
    public $fields = [
        'id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'autoIncrement' => true, 'precision' => null],
        'nome' => ['type' => 'string', 'length' => 200, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => 'Nome do Eleitor', 'precision' => null, 'fixed' => null],
        'cpf' => ['type' => 'string', 'length' => 30, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => 'CPF do Eleitor', 'precision' => null, 'fixed' => null],
        'dtnascimento' => ['type' => 'date', 'length' => null, 'null' => true, 'default' => null, 'comment' => 'Data de Nascimento do Eleitor', 'precision' => null],
        'telefone' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'comment' => 'Telefone do Eleitor', 'precision' => null, 'fixed' => null],
        'chave_filiado_sisfetems' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => 'Chave de FiliaÃ§Ã£o do Eleitor', 'precision' => null, 'autoIncrement' => null],
        'sindicato_id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => 'Id do Sindicato', 'precision' => null, 'autoIncrement' => null],
        'cidade_id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => 'Id da cidade', 'precision' => null, 'autoIncrement' => null],
        'origem_cadastro' => ['type' => 'integer', 'length' => 50, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => 'Origem do Cadastro', 'precision' => null, 'autoIncrement' => null],
        'tipo_avulso' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '0 - NÃƒO | 1 - SIM', 'precision' => null, 'autoIncrement' => null],
        'votou' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => '0', 'comment' => '0 - NÃƒO | 1 - SIM', 'precision' => null, 'autoIncrement' => null],
        'votou_dthora' => ['type' => 'datetime', 'length' => null, 'null' => true, 'default' => null, 'comment' => 'Data e Hora da VotaÃ§Ã£o', 'precision' => null],
        '_constraints' => [
            'primary' => ['type' => 'primary', 'columns' => ['id'], 'length' => []],
        ],
        '_options' => [
            'engine' => 'InnoDB',
            'collation' => 'latin1_swedish_ci'
        ],
    ];
    // @codingStandardsIgnoreEnd
    /**
     * Init method
     *
     * @return void
     */
    public function init()
    {
        $this->records = [
            [
                'id' => 1,
                'nome' => 'Lorem ipsum dolor sit amet',
                'cpf' => 'Lorem ipsum dolor sit amet',
                'dtnascimento' => '2021-05-31',
                'telefone' => 'Lorem ipsum dolor ',
                'chave_filiado_sisfetems' => 1,
                'sindicato_id' => 1,
                'cidade_id' => 1,
                'origem_cadastro' => 1,
                'tipo_avulso' => 1,
                'votou' => 1,
                'votou_dthora' => '2021-05-31 14:06:44',
            ],
        ];
        parent::init();
    }
}
