<?php
use Migrations\AbstractMigration;

class AlterTabelaCidadeSindicadoVinculoEstrangeiro extends AbstractMigration
{
    /**
     * Change Method.
     *
     * More information on this method is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     * @return void
     */
    public function change()
    {

        if($this->hasTable('filiado'))
        {
            $table = $this->table('filiado');
            
            $table->addForeignKey('sindicato_id', 'sindicato');

            $table->addForeignKey('cidade_id', 'cidade');

            $table->update();  
        }

        if($this->hasTable('sindicato'))
        {
            $table = $this->table('sindicato');
            
            $table->addForeignKey('cidade_id', 'cidade');

            $table->update();
        }

        if($this->hasTable('votacao_fetems'))
        {
            $table = $this->table('votacao_fetems');
            
            $table->addForeignKey('filiado_id', 'filiado');

            $table->addForeignKey('chapasfetems_id', 'chapasfetems');

            $table->update();
        }

        if($this->hasTable('votacao_chapasmunicipios'))
        {
            $table = $this->table('votacao_chapasmunicipios');
            
            $table->addForeignKey('filiado_id', 'filiado');

            $table->addForeignKey('chapasmunicipios_id', 'chapasmunicipios');

            $table->update();
        }

        if($this->hasTable('votacao_chapasregionais'))
        {
            $table = $this->table('votacao_chapasregionais');
            
            $table->addForeignKey('filiado_id', 'filiado');

            $table->addForeignKey('chapasregionais_id', 'chapasregionais');

            $table->update();
        }

    }
}
