<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Configuracao Model
 *
 * @method \App\Model\Entity\Configuracao get($primaryKey, $options = [])
 * @method \App\Model\Entity\Configuracao newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Configuracao[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Configuracao|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Configuracao saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Configuracao patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Configuracao[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Configuracao findOrCreate($search, callable $callback = null, $options = [])
 */
class ConfiguracaoTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('configuracao');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->dateTime('hora_inicio')
            ->allowEmptyDateTime('hora_inicio');

        $validator
            ->dateTime('hora_fim')
            ->allowEmptyDateTime('hora_fim');

        return $validator;
    }

    public function buscarDataHoraVotacao(){

        $dthoras = $this->find()->first();
        
        $dthora_inicio = date_format($dthoras->hora_inicio, 'Y-m-d H:i:s');
        $dthora_fim = date_format($dthoras->hora_fim, 'Y-m-d H:i:s');
        
        $dthora_atual = date('Y-m-d H:i:s');

        $periodo_votacao = $dthora_atual > $dthora_inicio && $dthora_atual < $dthora_fim;

        return (object) [
            'dthora_inicio' => $dthora_inicio,
            'dthora_fim' => $dthora_fim,
            'dthora_atual' => $dthora_atual,
            'periodo_votacao' => $periodo_votacao,
        ];
    }
}
