<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Sindicato Model
 *
 * @property \App\Model\Table\CidadeTable&\Cake\ORM\Association\BelongsTo $Cidade
 * @property \App\Model\Table\FiliadoTable&\Cake\ORM\Association\HasMany $Filiado
 *
 * @method \App\Model\Entity\Sindicato get($primaryKey, $options = [])
 * @method \App\Model\Entity\Sindicato newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Sindicato[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Sindicato|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Sindicato saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Sindicato patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Sindicato[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Sindicato findOrCreate($search, callable $callback = null, $options = [])
 */
class SindicatoTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('sindicato');
        $this->setDisplayField('nome');
        $this->setPrimaryKey('id');

        $this->belongsTo('Cidade', [
            'foreignKey' => 'cidade_id',
        ]);
        $this->hasMany('Filiado', [
            'foreignKey' => 'sindicato_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmptyString('nome');

        $validator
            ->integer('chave_sindicato_sisfetems')
            ->allowEmptyString('chave_sindicato_sisfetems');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['cidade_id'], 'Cidade'));

        return $rules;
    }
}
