<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * VotacaoChapasregionais Model
 *
 * @property \App\Model\Table\FiliadoTable&\Cake\ORM\Association\BelongsTo $Filiado
 * @property \App\Model\Table\ChapasregionaisTable&\Cake\ORM\Association\BelongsTo $Chapasregionais
 *
 * @method \App\Model\Entity\VotacaoChapasregionai get($primaryKey, $options = [])
 * @method \App\Model\Entity\VotacaoChapasregionai newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\VotacaoChapasregionai[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\VotacaoChapasregionai|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\VotacaoChapasregionai saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\VotacaoChapasregionai patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\VotacaoChapasregionai[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\VotacaoChapasregionai findOrCreate($search, callable $callback = null, $options = [])
 */
class VotacaoChapasregionaisTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('votacao_chapasregionais');
        $this->setDisplayField('chapasregionais_id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Filiado', [
            'foreignKey' => 'filiado_id',
        ]);
        $this->belongsTo('Chapasregionais', [
            'foreignKey' => 'chapasregionais_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->dateTime('dthora')
            ->allowEmptyDateTime('dthora');

        $validator
            ->scalar('ip')
            ->maxLength('ip', 20)
            ->allowEmptyString('ip');

        $validator
            ->integer('votacao_concluida')
            ->allowEmptyString('votacao_concluida');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['filiado_id'], 'Filiado'));
        $rules->add($rules->existsIn(['chapasregionais_id'], 'Chapasregionais'));

        return $rules;
    }
}
