<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Filiado $filiado
 */
?>
<div class="filiado form large-9 medium-8 columns content">
    <?= $this->Form->create($filiado, ['id' => 'form-filiado']) ?>
    <fieldset class="mb-4">
        <legend class="pb-3"><?= __('Identificação do Filiado Votante') ?></legend>
        <?php
            echo $this->Form->control('cpf', ['data-id-validador' => 'CPF', 'type' => 'number', 'value' => !empty($cpf) ? $cpf : "",'required' => 'required', 'label' => 'CPF', 'placeholder' => 'XXXXXXXXXXX', 'maxlength' => '11']);
            echo $this->Form->control('nome', ['data-id-validador' => 'Nome', 'required' => 'required']);
        ?>
        <div class="row">
            <div class="col-md-6">
                <?= $this->Form->control('dtnascimento', ['data-id-validador' => 'Data de Nascimento', 'required' => 'required', 'type' => 'text', 'label' => 'Data de Nascimento', 'empty' => true, 'placeholder' => 'dd/mm/yyyy', 'onkeyup' => 'mascaraDataNascimento(this)', 'maxlength' => '10']); ?>
            </div>
            <div class="col-md-6">
                <?= $this->Form->control('telefone', ['data-id-validador' => 'Telefone', 'required' => 'required', 'placeholder' => '(67) 99999-9999', 'onkeydown' => 'mascaraTelefone(this)', 'maxlength' => '16']); ?>
            </div>
        </div>
        <?php
            echo $this->Form->control('cidade_id', ['data-id-validador' => 'Cidade', 'required' => 'required', 'options' => $cidade, 'empty' => 'Selecione', 'onchange' => 'fillSindicato()']);
            echo $this->Form->control('sindicato_id', ['data-id-validador' => 'Sindicato', 'required' => 'required', 'empty' => 'Selecione']);
        ?>
    </fieldset>
    <div class="d-flex justify-content-between">
        <div>
            <?= $this->Form->button(__('Confirmar os dados e iniciar a votação'), ['type' => 'button', 'class' => 'm-3 mt-0 btn btn-success', 'onclick' => 'validaCPF($(this))']) ?>
        </div>
        <div>
            <?= $this->Html->link(__('Cancelar'), '/', ['type' => 'button', 'class' => 'm-4 mt-0 btn btn-danger']) ?>
        </div>
    </div>
    <?= $this->Form->end() ?>
</div>

<?= $this->Html->scriptBlock("
    setTimeout(() => {
        $('.message').addClass('hidden');
    }, 3500);
"); ?>